﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Linq.Expressions;  
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.Utilities; 

namespace VeteransAffairs.Registries.BusinessManager
{
    public class EFRPatientManager:BaseBO 
    {

        public EFRPatientManager() 
        {
            _defaultSortField = "PATIENT_ID";
            
        }

        private IQueryable<PATIENT> LinqAll()
        {
            //populate LinqAll
            IQueryable<PATIENT> tempLinq = (from e in _db.PATIENTs 
                                                      where e.REFERRALs.OfType<EFR_REFERRAL>().Any() select e);

            //TODO - add all business filtering rules 
             

            return tempLinq;

        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<PATIENT>(e => e.STD_INSTITUTION);
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT);
            lo.LoadWith<PATIENT>(e => e.STD_COMBATLOCATION);
            lo.LoadWith<PATIENT>(e => e.STD_GENDER);
            lo.LoadWith<PATIENT>(e => e.STD_MARITALSTATUS);
            lo.LoadWith<PATIENT>(e => e.STD_RACE);
            lo.LoadWith<PATIENT>(e => e.STD_ETHNICITY);
            lo.LoadWith<PATIENT>(e => e.STD_SERVICEBRANCH);

            lo.LoadWith<PATIENT>(e => e.REGISTRY_DEMOGRAPHICs);
            lo.AssociateWith<PATIENT>(p => p.REGISTRY_DEMOGRAPHICs.Where(rd => rd.STD_REGISTRY.CODE.Equals("EFR")));

            lo.LoadWith<REGISTRY_DEMOGRAPHIC>(e => e.STD_ADDRESSTYPE);
            //lo.LoadWith<REGISTRY_DEMOGRAPHIC>(e => e.STD_STATE);
            lo.LoadWith<PATIENT>(e => e.EFR_ICD9_DIAGs);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        private void SetLoadWithForGridViews(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<PATIENT>(e => e.STD_INSTITUTION);
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT);
            lo.LoadWith<PATIENT>(e => e.STD_SERVICEBRANCH);
            lo.LoadWith<PATIENT>(e => e.EFR_ICD9_DIAGs);
            lo.LoadWith<PATIENT>(e => e.RELATED_LAB_TESTs);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        public IEnumerable<PATIENT> Select(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                SetLoadWithForGridViews(_db);
                List<PATIENT> entities;
                entities = SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

                return entities;

            }
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            using (_db = GetDataContext())
            {
                SetLoadWithForGridViews(_db);
                return SelectLinqFilter().Count();
            }
        }

        private IQueryable<PATIENT> SelectLinqFilter()
        {
            IQueryable<PATIENT> linqFilter = LinqAll();
            return linqFilter;
        }


        public PATIENT SelectByID(int id)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                PATIENT patient = SelectByIDLinqFilter(id).SingleOrDefault();

                //if (patient != null)
                //{
                //    //patient.SetAsChangeTrackingRoot(true);

                //    int status = patient.EnforceBusinessRules(true, _db);
                //}

                return patient;

            }

        }

        private IQueryable<PATIENT> SelectByIDLinqFilter(int id)
        {
            IQueryable<PATIENT> linqFilter = LinqAll();

            linqFilter = from t in linqFilter where t.PATIENT_ID == id select t;

            return linqFilter;
        }

        public IEnumerable<PATIENT> SelectBySearchCriteria(string searchStringFirstName, 
            string searchStringLastName, string searchStringSSN, string searchStringICN,
            string sort, int startRow, int maxRows, bool efrPatients)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                SetLoadWithForGridViews(_db);
                IEnumerable<PATIENT> entities;
                entities = SelectBySearchCriteriaLinqFilter(searchStringFirstName,
          searchStringLastName, searchStringSSN, searchStringICN, efrPatients).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

                //var pats = entities.ToList();
                //pats.ForEach(s => s.DiagnosticsCount = s.EFR_ICD9_DIAGs.Count());  

                //return pats;

                return entities;
            }
        }

        public int SelectBySearchCriteriaCount(string searchStringFirstName,
            string searchStringLastName, string searchStringSSN, string searchStringICN, string sort, int startRow, int maxRows, bool efrPatients)
        {
            
            using (_db = GetDataContext())
            {
                SetLoadWithForGridViews(_db);
                return SelectBySearchCriteriaLinqFilter(searchStringFirstName,
          searchStringLastName, searchStringSSN, searchStringICN, efrPatients).Count();
            }
        }

        private IQueryable<PATIENT> SelectBySearchCriteriaLinqFilter(string searchStringFirstName,
            string searchStringLastName, string searchStringSSN,
            string searchStringICN, bool efrPatients)
        {
            IQueryable<PATIENT> linqFilter;

            if (efrPatients)
            {
                linqFilter = LinqAll();
            }
            else
            {
                linqFilter = (from e in _db.PATIENTs
                              where !e.REFERRALs.OfType<EFR_REFERRAL>().Any()
                              select e);
            }

            if (searchStringFirstName.NotNullOrEmpty())
            {
                linqFilter = from t in linqFilter where t.FIRST_NAME.Contains(searchStringFirstName.Trim()) select t;  

            }

            if (searchStringLastName.NotNullOrEmpty())
            {
                linqFilter = from t in linqFilter where t.LAST_NAME.Contains(searchStringLastName.Trim()) select t;

            }

            if (searchStringSSN.NotNullOrEmpty())
            {
                //var ssnChars = searchStringSSN.ToCharArray().ToList();
                
                //if (!ssnChars[3].Equals('-'))
                //    ssnChars.Insert(3, '-');

                //if (!ssnChars[6].Equals('-'))
                //    ssnChars.Insert(6, '-');

                //string formattedSSN = new string(ssnChars.ToArray());
                //string formattedSSN = String.Format("{0:000-00-0000}", int.Parse(searchStringSSN.Trim().Replace("-", "")));
                linqFilter = from t in linqFilter where t.Snum.Replace("-", "").Equals(searchStringSSN.Replace("-", "")) select t;

            }

            if (searchStringICN.NotNullOrEmpty())
            {
                linqFilter = from t in linqFilter where t.PATIENT_ICN.Equals(searchStringICN.Trim()) select t;

            }

              
            //linqFilter = from t in linqFilter where t.LAST_NAME.Contains(searchString) select t;

            return linqFilter;
        }


        
        public int Update(PATIENT patient)
        {
            int returnValue = 0;

            using (_db = GetDataContext())
            {
                
                _db.DeferredLoadingEnabled = false;

                //create an instance of the custom eventArgs in order to populate the id selected
                BOSaveSuccessEventArgs eventArgs = new BOSaveSuccessEventArgs();
                
                patient.SynchroniseWithDataContext(_db); //this line traverses all entities, attaching all of them as appropriate to the data context.

                try
                {
                    _db.SubmitChanges(ConflictMode.ContinueOnConflict);
                    returnValue =
                        eventArgs.SavedItemId = patient.PATIENT_ID;
                    eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;
                }
                catch (ChangeConflictException)
                {     
                    _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                    returnValue =
                        eventArgs.SavedItemId = patient.PATIENT_ID;
                        eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;
                }
                catch (Exception e)
                {
                    eventArgs.SaveStatusArg = SaveStatus.SaveFail;
                }
            
                RaiseSaveEvent(this, eventArgs);

            }

            return returnValue;
        }

        



    }
}
